USE PrzepisyPrzyklad;

CREATE VIEW R04_lista_wszystkich_skladnikow
AS
SELECT     NazwaSkladnika
FROM         Skladniki;


CREATE VIEW R04_glowne_informacje_o_przepisach
AS
SELECT   Przepisy.*
FROM         Przepisy
ORDER BY NazwaPrzepisu;


CREATE VIEW R04_identyfikatory_kategorii_przepisow
AS
SELECT DISTINCT IDKategoriiPrzepisu
FROM         Przepisy;


CREATE VIEW R04_kategorie_i_nazwy_przepisow
AS
SELECT   IDKategoriiPrzepisu, NazwaPrzepisu
FROM         Przepisy
ORDER BY IDKategoriiPrzepisu, NazwaPrzepisu;


CREATE VIEW R06_piec_pierwszych_przepisow
AS
SELECT     IDPrzepisu, NazwaPrzepisu, SposobPrzyrzadzania, Uwagi
FROM         Przepisy
WHERE     (IDPrzepisu BETWEEN 1 AND 5);


CREATE VIEW R06_dania_glowne_z_uwagami
AS
SELECT     NazwaPrzepisu, SposobPrzyrzadzania, Uwagi
FROM         Przepisy
WHERE     (IDKategoriiPrzepisu = 1) AND (Uwagi IS NOT NULL);


CREATE VIEW R06_miesa_z_wyjatkiem_kurczaka
AS
SELECT     NazwaSkladnika
FROM         Skladniki
WHERE     (NazwaSkladnika NOT LIKE '%KURCZAK%') AND (IDKategoriiSkladnika = 2);


CREATE VIEW R06_przepisy_bez_uwag
AS
SELECT     NazwaPrzepisu
FROM         Przepisy
WHERE     (Uwagi IS NULL);


/* MySQL nie obsługuje osadzonych wyrażeń SELECT w klauzuli FROM w następującym widoku.
Poniżej znajdziesz widoki skonstruowane na bazie innych widoków, dające ten sam rezultat.
CREATE VIEW R08_przepisy_z_wolowina_i_czosnkiem
AS
SELECT     PrzepisyWol.NazwaPrzepisu
FROM         (SELECT     Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
                       FROM          (Przepisy INNER JOIN
                                              Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu) INNER JOIN
                                              Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                       WHERE      Skladniki.NazwaSkladnika = 'Wołowina') PrzepisyWol INNER JOIN
                          (SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki_przepisow INNER JOIN
                                                   Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Czosnek') PrzepisyCzos ON PrzepisyWol.IDPrzepisu = PrzepisyCzos.IDPrzepisu;

Możesz jednak skopiować i wkleić powyższą instrukcję SELECT (z pominięciem CREATE VIEW) do okna zapytania, aby uzyskać ten rezultat bezpośrednio.
*/

CREATE VIEW R08_przepisy_wolowina
AS
SELECT     Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
                       FROM          (Przepisy INNER JOIN
                                              Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu) INNER JOIN
                                              Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                       WHERE      Skladniki.NazwaSkladnika = 'Wołowina';

CREATE VIEW R08_przepisy_czosnek
AS
SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki_przepisow INNER JOIN
                                                   Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Czosnek';

CREATE VIEW R08_przepisy_z_wolowina_i_czosnkiem
AS
SELECT     PrzepisyWol.NazwaPrzepisu
FROM R08_przepisy_wolowina As PrzepisyWol
INNER JOIN R08_przepisy_czosnek AS PrzepisyCzos
ON PrzepisyWol.IDPrzepisu = PrzepisyCzos.IDPrzepisu;


CREATE VIEW R08_przepisy_z_wolowina_lub_czosnkiem
AS
SELECT DISTINCT Przepisy.NazwaPrzepisu
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu
WHERE     (Skladniki_przepisow.IDSkladnika IN (1, 9));

/* MySQL nie obsługuje osadzonych wyrażeń SELECT w klauzuli FROM w następującym widoku.
Poniżej znajdziesz widoki skonstruowane na bazie innych widoków, dające ten sam rezultat.
CREATE VIEW R08_skladniki_ta_sama_miara
AS
SELECT     Pierwszy_skladnik.NazwaPierwszegoSkladnika, Pierwszy_skladnik.OpisMiary, Drugi_skladnik.NazwaDrugiegoSkladnika
FROM         (SELECT     Skladniki.NazwaSkladnika AS NazwaPierwszegoSkladnika, Miary.OpisMiary
                       FROM          Skladniki INNER JOIN
                                              Miary ON Skladniki.IDMiaryIlosci = Miary.IDMiaryIlosci) Pierwszy_skladnik INNER JOIN
                          (SELECT     Skladniki.NazwaSkladnika AS NazwaDrugiegoSkladnika, Miary.OpisMiary
                            FROM          Skladniki INNER JOIN
                                                   Miary ON Skladniki.IDMiaryIlosci = Miary.IDMiaryIlosci) Drugi_skladnik ON 
                      Pierwszy_skladnik.NazwaPierwszegoSkladnika <> Drugi_skladnik.NazwaDrugiegoSkladnika AND 
                      Pierwszy_skladnik.OpisMiary = Drugi_skladnik.OpisMiary;

Możesz jednak skopiować i wkleić powyższą instrukcję SELECT (z pominięciem CREATE VIEW) do okna zapytania, aby uzyskać ten rezultat bezpośrednio.
*/

CREATE VIEW R08_jeden_skladnik
AS
SELECT     Skladniki.NazwaSkladnika, Miary.OpisMiary
                       FROM          Skladniki INNER JOIN
                                              Miary ON Skladniki.IDMiaryIlosci = Miary.IDMiaryIlosci;

CREATE VIEW R08_skladniki_ta_sama_miara
AS
SELECT     Pierwszy_skladnik.NazwaSkladnika As PierwszySkladnik, Pierwszy_skladnik.OpisMiary,
  Drugi_skladnik.NazwaSkladnika As DrugiSkladnik
FROM     R08_jeden_skladnik As Pierwszy_skladnik
INNER JOIN
         R08_jeden_skladnik As Drugi_skladnik
ON 
         Pierwszy_skladnik.NazwaSkladnika <> Drugi_skladnik.NazwaSkladnika AND
         Pierwszy_skladnik.OpisMiary = Drugi_skladnik.OpisMiary;


CREATE VIEW R08_skladniki_dan_glownych
AS
SELECT     Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika, Miary.OpisMiary, Skladniki_przepisow.Ilosc
FROM         Kategorie_przepisow INNER JOIN
                      Przepisy ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika INNER JOIN
                      Miary ON Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci
WHERE     (Kategorie_przepisow.OpisKategoriiPrzepisu = 'Dania główne');

/* MySQL nie obsługuje osadzonych wyrażeń SELECT w klauzuli FROM w następującym widoku.
Poniżej znajdziesz widoki skonstruowane na bazie innych widoków, dające ten sam rezultat.
CREATE VIEW R08_przepisy_zawierajace_marchew
AS
SELECT     Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika INNER JOIN
                          (SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki INNER JOIN
                                                   Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Marchew') Marchewka ON Przepisy.IDPrzepisu = Marchewka.IDPrzepisu;

Możesz jednak skopiować i wkleić powyższą instrukcję SELECT (z pominięciem CREATE VIEW) do okna zapytania, aby uzyskać ten rezultat bezpośrednio.
*/

CREATE VIEW R08_przepisy_marchew
AS
SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki INNER JOIN
                                                   Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Marchew';

CREATE VIEW R08_przepisy_zawierajace_marchew
AS
SELECT     Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika INNER JOIN
                          R08_przepisy_marchew AS Marchewka ON Przepisy.IDPrzepisu = Marchewka.IDPrzepisu;


CREATE VIEW R08_przepisy_zawierajace_nabial
AS
SELECT DISTINCT Przepisy.NazwaPrzepisu
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika INNER JOIN
                      Kategorie_skladnikow ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE     (Kategorie_skladnikow.OpisKategoriiSkladnika = 'Nabiał');


CREATE VIEW R08_salatki
AS
SELECT     Przepisy.NazwaPrzepisu
FROM         Przepisy INNER JOIN
                      Kategorie_przepisow ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu
WHERE     (Kategorie_przepisow.OpisKategoriiPrzepisu = 'Sałatki');


/* MySQL nie obsługuje osadzonych wyrażeń SELECT w klauzuli FROM w następującym widoku.
Poniżej znajdziesz widoki skonstruowane na bazie innych widoków, dające ten sam rezultat.
CREATE VIEW R09_wszystkie_skladniki_dowolne_przepisy
AS
SELECT     Skladniki.NazwaSkladnika, P.IDPrzepisu, P.NazwaPrzepisu
FROM         Skladniki LEFT OUTER JOIN
                          (SELECT DISTINCT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, Skladniki_przepisow.IDSkladnika
                            FROM          Przepisy INNER JOIN
                                                   Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu) P ON Skladniki.IDSkladnika = P.IDSkladnika;

Możesz jednak skopiować i wkleić powyższą instrukcję SELECT (z pominięciem CREATE VIEW) do okna zapytania, aby uzyskać ten rezultat bezpośrednio.
*/

CREATE VIEW R09_wszystkie_skladniki_przepisow
AS
SELECT DISTINCT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, Skladniki_przepisow.IDSkladnika
FROM          Przepisy INNER JOIN
              Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu;

CREATE VIEW R09_wszystkie_skladniki_dowolne_przepisy
AS
SELECT     Skladniki.NazwaSkladnika, P.IDPrzepisu, P.NazwaPrzepisu
FROM         Skladniki LEFT OUTER JOIN
                          R09_wszystkie_skladniki_przepisow AS P ON Skladniki.IDSkladnika = P.IDSkladnika;


/* MySQL nie obsługuje złączenia FULL OUTER JOIN w następującym widoku.
Poniżej znajdziesz zapytanie skonstruowane z użyciem operacji UNION na innych widokach (podobnie jak w Accessie), dające ten sam rezultat.
CREATE VIEW R09_wszystkie_kategorie_przepisow_wszystkie_przepisy
AS
SELECT   Kategorie_przepisow.OpisKategoriiPrzepisu, Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika, 
                      Skladniki_przepisow.NumerKrokuPrzepisu, Skladniki_przepisow.Ilosc, Miary.OpisMiary
FROM (((Kategorie_przepisow 
        FULL OUTER JOIN Przepisy 
          ON Kategorie_przepisow.IDKategoriiPrzepisu = Przepisy.IDKategoriiPrzepisu) 
        LEFT OUTER JOIN Skladniki_przepisow 
          ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu) 
        INNER JOIN Miary 
          ON Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci) 
        FULL OUTER JOIN Skladniki 
          ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
ORDER BY Przepisy.NazwaPrzepisu DESC, Skladniki_przepisow.NumerKrokuPrzepisu;

Ponieważ MySQL nie obsługuje złączenia FULL OUTER JOIN, nie da się wykonać tego zapytania z poziomu okna zapytań.
*/

CREATE VIEW R09_wszystkie_skladniki1
AS
SELECT Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika, Skladniki_przepisow.NumerKrokuPrzepisu,
     Skladniki_przepisow.Ilosc, Miary.OpisMiary, Przepisy.IDKategoriiPrzepisu
     FROM (((Przepisy INNER JOIN Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu)
     INNER JOIN Miary ON Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci)
     INNER JOIN Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika);

CREATE VIEW R09_wszystkie_skladniki2
AS
SELECT Kategorie_przepisow.OpisKategoriiPrzepisu, Przepisy.NazwaPrzepisu, Skladniki_przepisow.NumerKrokuPrzepisu,
   Skladniki_przepisow.Ilosc, Miary.OpisMiary, Skladniki_przepisow.IDSkladnika
   FROM  (Miary INNER JOIN
     ((Kategorie_przepisow INNER JOIN Przepisy ON Kategorie_przepisow.IDKategoriiPrzepisu = Przepisy.IDKategoriiPrzepisu)
     INNER JOIN Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu)
     ON Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci);

CREATE VIEW R09_wszystkie_kategorie_przepisow_wszystkie_przepisy
AS
SELECT Kategorie_przepisow.OpisKategoriiPrzepisu, R1.NazwaPrzepisu, R1.NazwaSkladnika, R1.NumerKrokuPrzepisu,
  R1.Ilosc, R1.OpisMiary
FROM Kategorie_przepisow
  LEFT JOIN R09_wszystkie_skladniki1 AS R1
     ON Kategorie_przepisow.IDKategoriiPrzepisu = R1.IDKategoriiPrzepisu
UNION
SELECT R1.OpisKategoriiPrzepisu, R1.NazwaPrzepisu, Skladniki.NazwaSkladnika, R1.NumerKrokuPrzepisu,
  R1.Ilosc, R1.OpisMiary
FROM Skladniki
  LEFT JOIN R09_wszystkie_skladniki2 AS R1
     ON Skladniki.IDSkladnika = R1.IDSkladnika
WHERE R1.NazwaPrzepisu IS NULL
ORDER BY 1 DESC , 2, 3;

CREATE VIEW R09_wszystkie_kategorie_i_pasujace_przepisy
AS
SELECT     Kategorie_przepisow.OpisKategoriiPrzepisu, Przepisy.NazwaPrzepisu
FROM         Kategorie_przepisow LEFT OUTER JOIN
                      Przepisy ON Kategorie_przepisow.IDKategoriiPrzepisu = Przepisy.IDKategoriiPrzepisu;

CREATE VIEW R09_niewykorzystane_skladniki
AS
SELECT     Skladniki.NazwaSkladnika
FROM         Skladniki LEFT OUTER JOIN
                      Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE     (Skladniki_przepisow.IDPrzepisu IS NULL);

CREATE VIEW R09_kategorie_bez_przepisow
AS
SELECT     Kategorie_przepisow.OpisKategoriiPrzepisu
FROM         Kategorie_przepisow LEFT OUTER JOIN
                      Przepisy ON Kategorie_przepisow.IDKategoriiPrzepisu = Przepisy.IDKategoriiPrzepisu
WHERE     (Przepisy.IDPrzepisu IS NULL);


/* MySQL nie obsługuje osadzonych wyrażeń SELECT w klauzuli FROM w następującym widoku.
Poniżej znajdziesz widoki skonstruowane na bazie innych widoków, dające ten sam rezultat.
CREATE VIEW R09_salatki_zupy_dania_glowne
AS
SELECT     KPFiltrowana.NazwaKategorii, P.NazwaPrzepisu
FROM         (SELECT     KP.IDKategoriiPrzepisu, KP.OpisKategoriiPrzepisu AS NazwaKategorii
                       FROM          Kategorie_przepisow AS KP
                       WHERE      KP.OpisKategoriiPrzepisu = 'Sałatki' OR
                                              KP.OpisKategoriiPrzepisu = 'Zupy' OR
                                              KP.OpisKategoriiPrzepisu = 'Dania główne') KPFiltrowana LEFT OUTER JOIN
                      Przepisy AS P ON KPFiltrowana.IDKategoriiPrzepisu = P.IDKategoriiPrzepisu;

Możesz jednak skopiować i wkleić powyższą instrukcję SELECT (z pominięciem CREATE VIEW) do okna zapytania, aby uzyskać ten rezultat bezpośrednio.
*/

CREATE VIEW R09_salatka_zupa_glowne
AS
SELECT     KP.IDKategoriiPrzepisu, KP.OpisKategoriiPrzepisu AS NazwaKategorii
 FROM          Kategorie_przepisow AS KP
 WHERE      KP.OpisKategoriiPrzepisu = 'Sałatki' OR
            KP.OpisKategoriiPrzepisu = 'Zupy' OR
            KP.OpisKategoriiPrzepisu = 'Dania główne';

CREATE VIEW R09_salatki_zupy_dania_glowne
AS
SELECT     KPFiltrowana.NazwaKategorii, P.NazwaPrzepisu
FROM         R09_salatka_zupa_glowne AS KPFiltrowana LEFT OUTER JOIN
                      Przepisy AS P ON KPFiltrowana.IDKategoriiPrzepisu = P.IDKategoriiPrzepisu;


CREATE VIEW R10_kategorie_przepisy_skladniki
AS
SELECT     Kategorie_przepisow.OpisKategoriiPrzepisu AS NazwaWIndeksie, 'Kategoria przepisu' AS Typ
FROM         Kategorie_przepisow
UNION
SELECT     Przepisy.NazwaPrzepisu, 'Przepis' AS Typ
FROM         Przepisy
UNION
SELECT     Skladniki.NazwaSkladnika, 'Składnik' AS Typ
FROM         Skladniki;

CREATE VIEW R10_jednostki_miary_skladnikow_w_przepisach
AS
SELECT     Skladniki.NazwaSkladnika, Miary.OpisMiary, 'Składnik' AS Typ
FROM         Miary INNER JOIN
                      Skladniki ON (Miary.IDMiaryIlosci = Skladniki.IDMiaryIlosci)
UNION
SELECT     Skladniki.NazwaSkladnika, Miary.OpisMiary, 'Przepis' AS Typ
FROM         (Miary INNER JOIN
                      Skladniki_przepisow ON (Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci)) INNER JOIN
                      Skladniki ON (Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika);

CREATE VIEW R11_liczba_przepisow_w_kategoriach
AS
SELECT     IDKategoriiPrzepisu, OpisKategoriiPrzepisu,
                          (SELECT     COUNT(*)
                            FROM          Przepisy
                            WHERE      Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu) AS LiczbaPrzepisow
FROM         Kategorie_przepisow;

CREATE VIEW R11_skladniki_uzyte_w_niestandardowych_ilosciach
AS
SELECT     IDSkladnika, NazwaSkladnika, IDMiaryIlosci
FROM         Skladniki
WHERE     (IDMiaryIlosci <> ANY
                          (SELECT     Skladniki_przepisow.IDMiaryIlosci
                            FROM          Skladniki_przepisow
                            WHERE      Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika));

CREATE VIEW R11_liczba_przepisow_z_roznymi_rodzajami_mies
AS
SELECT     Kategorie_skladnikow.OpisKategoriiSkladnika, Skladniki.NazwaSkladnika,
                          (SELECT     COUNT(*)
                            FROM          Skladniki_przepisow
                            WHERE      Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) AS LiczbaPrzepisow
FROM         Kategorie_skladnikow INNER JOIN
                      Skladniki ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE     (Kategorie_skladnikow.OpisKategoriiSkladnika = 'Mięsa');

CREATE VIEW R11_skladniki_przepisow_z_marchwia
AS
SELECT     Przepisy.NazwaPrzepisu, Skladniki.NazwaSkladnika
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE     (Przepisy.IDPrzepisu IN
                          (SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki INNER JOIN
                                                   Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Marchew'));

CREATE VIEW R12_liczba_skladnikow_mierzonych_szklanka
AS
SELECT     COUNT(*) AS LiczbaSkladnikow
FROM         Skladniki INNER JOIN
                      Miary ON Skladniki.IDMiaryIlosci = Miary.IDMiaryIlosci
WHERE     (Miary.OpisMiary = 'Szklanka');

CREATE VIEW R12_liczba_przepisow_na_dania_glowne
AS
SELECT DISTINCT COUNT(*) AS LiczbaPrzepisow
FROM         Przepisy INNER JOIN
                      Kategorie_przepisow ON Przepisy.IDKategoriiPrzepisu = Kategorie_przepisow.IDKategoriiPrzepisu
WHERE     (Kategorie_przepisow.OpisKategoriiPrzepisu = 'Dania główne');

CREATE VIEW R12_przepis_z_najwieksza_liczba_zabkow_czosnku
AS
SELECT DISTINCT Przepisy.NazwaPrzepisu
FROM         Przepisy INNER JOIN
                      Skladniki_przepisow ON Przepisy.IDPrzepisu = Skladniki_przepisow.IDPrzepisu INNER JOIN
                      Skladniki ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika
WHERE     (Skladniki.NazwaSkladnika = 'Czosnek') AND (Skladniki_przepisow.Ilosc =
                          (SELECT     MAX(Ilosc)
                            FROM          Skladniki_przepisow INNER JOIN
                                                   Skladniki ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika
                            WHERE      NazwaSkladnika = 'Czosnek'));

CREATE VIEW R12_przepisy_z_wolowina
AS
SELECT     COUNT(*) AS LiczbaPrzepisow
FROM         Przepisy
WHERE     (IDPrzepisu IN
                          (SELECT     IDPrzepisu
                            FROM          Skladniki_przepisow INNER JOIN
                                                   Skladniki ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika
                            WHERE      NazwaSkladnika LIKE 'wołow%'));

CREATE VIEW R12_calkowita_ilosc_soli_w_przepisach
AS
SELECT     SUM(Skladniki_przepisow.Ilosc) AS LiczbaLyzeczek
FROM         Skladniki_przepisow INNER JOIN
                      Skladniki ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika
WHERE     (Skladniki.NazwaSkladnika = 'Sól');

CREATE VIEW R13_liczba_roznych_przepisow_dla_kat_skladnikow
AS
SELECT     Kategorie_skladnikow.OpisKategoriiSkladnika, COUNT(DISTINCT Skladniki_przepisow.IDPrzepisu) AS LiczbaIDPrzepisow
FROM         Kategorie_skladnikow INNER JOIN
                      Skladniki ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika INNER JOIN
                      Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
GROUP BY Kategorie_skladnikow.OpisKategoriiSkladnika;

CREATE VIEW R13_liczba_przepisow_z_miesem_grupowanie
AS
SELECT     Kategorie_skladnikow.OpisKategoriiSkladnika, Skladniki.NazwaSkladnika, COUNT(*) AS LiczbaPrzepisow
FROM         Kategorie_skladnikow INNER JOIN
                      Skladniki ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika INNER JOIN
                      Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE     (Kategorie_skladnikow.OpisKategoriiSkladnika = 'Mięsa')
GROUP BY Kategorie_skladnikow.OpisKategoriiSkladnika, Skladniki.NazwaSkladnika;

CREATE VIEW R13_liczba_przepisow_z_miesem_podzapytanie
AS
SELECT     Kategorie_skladnikow.OpisKategoriiSkladnika, Skladniki.NazwaSkladnika,
                          (SELECT     COUNT(*)
                            FROM          Skladniki_przepisow
                            WHERE      Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) AS LiczbaPrzepisow
FROM         Kategorie_skladnikow INNER JOIN
                      Skladniki ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE     (Kategorie_skladnikow.OpisKategoriiSkladnika = 'Mięsa');

CREATE VIEW R13_laczna_ilosc_skladnikow
AS
SELECT     Skladniki.NazwaSkladnika, Miary.OpisMiary, SUM(Skladniki_przepisow.Ilosc) AS SumaIlosci
FROM         Skladniki INNER JOIN
                      (Miary INNER JOIN
                      Skladniki_przepisow ON Miary.IDMiaryIlosci = Skladniki_przepisow.IDMiaryIlosci)
                       ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
GROUP BY Skladniki.NazwaSkladnika, Miary.OpisMiary;

CREATE VIEW R14_kategorie_przepisow_wymagajace_mnostwa_soli
AS
SELECT Kategorie_przepisow.OpisKategoriiPrzepisu, Skladniki.NazwaSkladnika, Sum(Skladniki_przepisow.Ilosc) AS SumaLyzeczekSoli
FROM (((Kategorie_przepisow INNER JOIN Przepisy 
ON Kategorie_przepisow.IDKategoriiPrzepisu=Przepisy.IDKategoriiPrzepisu) 
INNER JOIN Skladniki_przepisow 
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu) 
INNER JOIN Skladniki 
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika) 
INNER JOIN Miary 
ON Miary.IDMiaryIlosci=Skladniki_przepisow.IDMiaryIlosci
WHERE Skladniki.NazwaSkladnika='Sól'
   And Miary.OpisMiary='Łyżeczka'
GROUP BY Kategorie_przepisow.OpisKategoriiPrzepisu, Skladniki.NazwaSkladnika
HAVING Sum(Skladniki_przepisow.Ilosc)>3;

CREATE VIEW R14_kategorie_z_co_najmniej_dwoma_przepisami
AS
SELECT     Kategorie_przepisow.OpisKategoriiPrzepisu, COUNT(Przepisy.IDPrzepisu) AS LiczbaIDPrzepisow
FROM         Kategorie_przepisow INNER JOIN
                      Przepisy ON Kategorie_przepisow.IDKategoriiPrzepisu = Przepisy.IDKategoriiPrzepisu
GROUP BY Kategorie_przepisow.OpisKategoriiPrzepisu
HAVING      (COUNT(Przepisy.IDPrzepisu) >= 2);

CREATE VIEW R14_przepisy_z_wołowiną_i_czosnkiem
AS
SELECT     NazwaPrzepisu
FROM         Przepisy
WHERE     (IDPrzepisu IN
                          (SELECT     Skladniki_przepisow.IDPrzepisu
                            FROM          Skladniki INNER JOIN
                                                   Skladniki_przepisow ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
                            WHERE      Skladniki.NazwaSkladnika = 'Wołowina' OR
                                                   Skladniki.NazwaSkladnika = 'Czosnek'
                            GROUP BY Skladniki_przepisow.IDPrzepisu
                            HAVING      COUNT(Skladniki_przepisow.IDPrzepisu) = 2));

CREATE VIEW R18_skladniki_bez_przepisow
AS 
SELECT Skladniki.NazwaSkladnika
FROM Skladniki
WHERE Skladniki.IDSkladnika NOT IN 
(SELECT Skladniki_przepisow.IDSkladnika FROM Skladniki_przepisow);


CREATE VIEW R18_skladniki_nieuzyte_w_gulaszu_pollo_steku_NOTIN
AS 
SELECT Skladniki.IDSkladnika, Skladniki.NazwaSkladnika
FROM Skladniki
WHERE Skladniki.IDSkladnika NOT IN 
(SELECT Skladniki_przepisow.IDSkladnika 
FROM Skladniki_przepisow
INNER JOIN Przepisy 
ON Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu 
WHERE NazwaPrzepisu IN 
('Gulasz irlandzki', 'Pollo z kurczakiem', 'Stek wołowy'));


CREATE VIEW R18_kategorie_przepisow_bez_przepisow_NOT_IN
AS 
SELECT Kategorie_przepisow.OpisKategoriiPrzepisu
FROM Kategorie_przepisow
WHERE Kategorie_przepisow.IDKategoriiPrzepisu NOT IN 
(SELECT Przepisy.IDKategoriiPrzepisu 
FROM Przepisy);


CREATE VIEW R18_przepisy_co_najmniej_3_takie_same_skladniki
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, P2.IDPrzepisu AS P2ID, P2.NazwaPrzepisu AS P2Nazwa, Count(Skladniki_przepisow.IDPrzepisu) AS LiczbaIDPrzepisow
FROM ((Przepisy
INNER JOIN Skladniki_przepisow
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu)
INNER JOIN Skladniki_przepisow AS SP2
ON Skladniki_przepisow.IDSkladnika=SP2.IDSkladnika)
INNER JOIN Przepisy AS P2
ON P2.IDPrzepisu=SP2.IDPrzepisu
WHERE SP2.IDPrzepisu>Przepisy.IDPrzepisu
GROUP BY Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu, P2.IDPrzepisu, P2.NazwaPrzepisu
HAVING Count(Skladniki_przepisow.IDPrzepisu)>=3;


CREATE VIEW R18_przepisy_z_wolowina_i_czosnkiem
AS 
SELECT Przepisy.NazwaPrzepisu, Przepisy.SposobPrzyrzadzania
FROM Przepisy
WHERE EXISTS 
(SELECT Skladniki_przepisow.*
FROM Skladniki
INNER JOIN Skladniki_przepisow
ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE Skladniki.NazwaSkladnika='Wołowina'
AND Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu)
AND EXISTS 
(SELECT Skladniki_przepisow.*
FROM Skladniki
INNER JOIN Skladniki_przepisow
ON Skladniki.IDSkladnika = Skladniki_przepisow.IDSkladnika
WHERE Skladniki.NazwaSkladnika='Czosnek'
AND Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu);


CREATE VIEW R18_przepisy_wolowina_cebula_marchew
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE Przepisy.IDPrzepisu IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Wołowina') 
AND Przepisy.IDPrzepisu IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Cebula') 
AND Przepisy.IDPrzepisu IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Marchew');


/* MySQL nie obsługuje osadzonych wyrażeń SELECT w klauzuli FROM w następującym widoku.
Poniżej znajdziesz widoki skonstruowane na bazie innych widoków, dające ten sam rezultat.
CREATE VIEW R18_przepisy_z_maslem_BEZ_wolowiny_cebuli_marchwi_GROUPBY
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM ((Przepisy
INNER JOIN Skladniki_przepisow
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu)
INNER JOIN Skladniki
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika) 
LEFT JOIN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow INNER JOIN Skladniki
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika 
WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew'))  AS RIBOC
ON Przepisy.IDPrzepisu=RIBOC.IDPrzepisu
WHERE Skladniki.NazwaSkladnika='Masło'
AND RIBOC.IDPrzepisu Is Null
GROUP BY Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
HAVING COUNT(RIBOC.IDPrzepisu)=0;

Możesz jednak skopiować i wkleić powyższą instrukcję SELECT (z pominięciem CREATE VIEW) do okna zapytania, aby uzyskać ten rezultat bezpośrednio.
*/

CREATE VIEW R18_RIBOC
AS
SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow INNER JOIN Skladniki
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika 
WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew');

CREATE VIEW R18_przepisy_z_maslem_BEZ_wolowiny_cebuli_marchwi_GROUPBY
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM ((Przepisy
INNER JOIN Skladniki_przepisow
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu)
INNER JOIN Skladniki
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika) 
LEFT JOIN R18_RIBOC  AS RIBOC
ON Przepisy.IDPrzepisu=RIBOC.IDPrzepisu
WHERE Skladniki.NazwaSkladnika='Masło'
AND RIBOC.IDPrzepisu Is Null
GROUP BY Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
HAVING COUNT(RIBOC.IDPrzepisu)=0;


CREATE VIEW R18_przepisy_bez_nabialu_DOBRZE
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE Przepisy.IDPrzepisu NOT IN
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM (Skladniki_przepisow
INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) 
INNER JOIN Kategorie_skladnikow
ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE Kategorie_skladnikow.OpisKategoriiSkladnika = 'Masło')
AND Przepisy.IDPrzepisu NOT IN
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM (Skladniki_przepisow
INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) 
INNER JOIN Kategorie_skladnikow
ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE Kategorie_skladnikow.OpisKategoriiSkladnika = 'Ser')
AND Przepisy.IDPrzepisu NOT IN
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM (Skladniki_przepisow
INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika) 
INNER JOIN Kategorie_skladnikow
ON Kategorie_skladnikow.IDKategoriiSkladnika = Skladniki.IDKategoriiSkladnika
WHERE Kategorie_skladnikow.OpisKategoriiSkladnika = 'Nabiał');


CREATE VIEW R18_przepisy_bez_nabialu_ZLE
AS 
SELECT DISTINCT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM ((Przepisy
INNER JOIN Skladniki_przepisow
ON Przepisy.IDPrzepisu=Skladniki_przepisow.IDPrzepisu)
INNER JOIN Skladniki
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika)
INNER JOIN Kategorie_skladnikow
ON Kategorie_skladnikow.IDKategoriiSkladnika=Skladniki.IDKategoriiSkladnika
WHERE Kategorie_skladnikow.OpisKategoriiSkladnika Not In ('Masło','Ser','Nabiał');


/* MySQL nie obsługuje osadzonych wyrażeń SELECT w klauzuli FROM w następującym widoku.
Poniżej znajdziesz widoki skonstruowane na bazie innych widoków, dające ten sam rezultat.
CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_GROUPBY
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy LEFT JOIN (SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow 
INNER JOIN Skladniki 
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika 
WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew'))  AS RIBOC
ON Przepisy.IDPrzepisu=RIBOC.IDPrzepisu
WHERE RIBOC.IDPrzepisu IS NULL
GROUP BY Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
HAVING COUNT(RIBOC.IDPrzepisu)=0;

Możesz jednak skopiować i wkleić powyższą instrukcję SELECT (z pominięciem CREATE VIEW) do okna zapytania, aby uzyskać ten rezultat bezpośrednio.
*/

CREATE VIEW R18_przepisy_wolowina_cebula_marchew_G
AS
SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow 
INNER JOIN Skladniki 
ON Skladniki.IDSkladnika=Skladniki_przepisow.IDSkladnika 
WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew');

CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_GROUPBY
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy LEFT JOIN R18_przepisy_wolowina_cebula_marchew_G AS RIBOC
ON Przepisy.IDPrzepisu=RIBOC.IDPrzepisu
WHERE RIBOC.IDPrzepisu IS NULL
GROUP BY Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
HAVING COUNT(RIBOC.IDPrzepisu)=0;


CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_NOTEXISTS
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE NOT EXISTS  
(SELECT * FROM Skladniki_przepisow 
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika IN ('Wołowina', 'Cebula', 'Marchew') 
AND Skladniki_przepisow.IDPrzepisu = Przepisy.IDPrzepisu);


CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_NOTIN_1
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE Przepisy.IDPrzepisu NOT IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Wołowina') 
AND Przepisy.IDPrzepisu NOT IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Cebula') 
AND Przepisy.IDPrzepisu NOT IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika = 'Marchew');


CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_NOTIN_2
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy
WHERE Przepisy.IDPrzepisu NOT IN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow
INNER JOIN Skladniki 
ON Skladniki_przepisow.IDSkladnika = Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika IN ('Wołowina', 'Cebula', 'Marchew'));


/* MySQL nie obsługuje osadzonych wyrażeń SELECT w klauzuli FROM w następującym widoku.
Poniżej znajdziesz widoki skonstruowane na bazie innych widoków, dające ten sam rezultat.
CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_OUTERJOIN
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy LEFT JOIN 
(SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika=Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew'))  AS PrzepWolMarCeb
ON Przepisy.IDPrzepisu=PrzepWolMarCeb.IDPrzepisu
WHERE PrzepWolMarCeb.IDPrzepisu Is Null;

Możesz jednak skopiować i wkleić powyższą instrukcję SELECT (z pominięciem CREATE VIEW) do okna zapytania, aby uzyskać ten rezultat bezpośrednio.
*/

CREATE VIEW R18_PrzepWolMarCeb
AS
SELECT Skladniki_przepisow.IDPrzepisu 
FROM Skladniki_przepisow INNER JOIN Skladniki
ON Skladniki_przepisow.IDSkladnika=Skladniki.IDSkladnika 
WHERE Skladniki.NazwaSkladnika In ('Wołowina','Cebula','Marchew');

CREATE VIEW R18_przepisy_BEZ_wolowiny_cebuli_marchwi_OUTERJOIN
AS 
SELECT Przepisy.IDPrzepisu, Przepisy.NazwaPrzepisu
FROM Przepisy LEFT JOIN 
R18_PrzepWolMarCeb  AS PrzepWolMarCeb
ON Przepisy.IDPrzepisu=PrzepWolMarCeb.IDPrzepisu
WHERE PrzepWolMarCeb.IDPrzepisu Is Null;
